<?php

if ( ! function_exists( 'kropp_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function kropp_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'kropp_filter_mobile_header_template', kropp_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'kropp_action_page_header_template', 'kropp_load_page_mobile_header' );
}

if ( ! function_exists( 'kropp_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function kropp_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'kropp_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'kropp' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'kropp_action_after_include_modules', 'kropp_register_mobile_navigation_menus' );
}
