<?php

if ( ! function_exists( 'kropp_core_add_cards_gallery_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function kropp_core_add_cards_gallery_shortcode( $shortcodes ) {
		$shortcodes[] = 'KroppCore_Cards_Gallery_Shortcode';

		return $shortcodes;
	}

	add_filter( 'kropp_core_filter_register_shortcodes', 'kropp_core_add_cards_gallery_shortcode' );
}

if ( class_exists( 'KroppCore_Shortcode' ) ) {
	class KroppCore_Cards_Gallery_Shortcode extends KroppCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( KROPP_CORE_SHORTCODES_URL_PATH . '/cards-gallery' );
			$this->set_base( 'kropp_core_cards_gallery' );
			$this->set_name( esc_html__( 'Cards Gallery', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds cards gallery holder', 'kropp-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'link_target',
					'title'         => esc_html__( 'Link Target', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'orientation',
					'title'         => esc_html__( 'Info Position', 'kropp-core' ),
					'options'       => array(
						''      => esc_html__( 'Default', 'kropp-core' ),
						'right' => esc_html__( 'Shuffled Right', 'kropp-core' ),
						'left'  => esc_html__( 'Shuffled Left', 'kropp-core' ),
					),
					'default_value' => 'right',
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'appear_animation',
                    'title'         => esc_html__( 'Appear Animation', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                )
            );
			$this->set_option(
				array(
					'field_type'  => 'repeater',
					'name'        => 'children',
					'title'       => esc_html__( 'Image Items (two items allowed)', 'kropp-core' ),
					'items'       => array(
						array(
							'field_type'    => 'text',
							'name'          => 'item_link',
							'title'         => esc_html__( 'Link', 'kropp-core' ),
							'default_value' => '',
						),
						array(
							'field_type' => 'image',
							'name'       => 'item_image',
							'title'      => esc_html__( 'Item Image', 'kropp-core' ),
						),
                        array(
                            'field_type' => 'select',
                            'name'       => 'item_arrow_style',
                            'title'      => esc_html__( 'Arrow Style', 'kropp-core' ),
                            'options'    => array(
                                ''      => esc_html__( 'Default', 'kropp-core' ),
                                'light' => esc_html__( 'Light', 'kropp-core' ),
                                'dark'  => esc_html__( 'Dark', 'kropp-core' ),
                            ),
                        ),
					),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
            $atts['this_object']    = $this;
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return kropp_core_get_template_part( 'shortcodes/cards-gallery', 'templates/cards-gallery', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-cards-gallery';
			$holder_classes[] = ! empty( $atts['orientation'] ) ? 'qodef-orientation--' . $atts['orientation'] : 'qodef-orientation--right';
			$holder_classes[] = ! empty( $atts['appear_animation'] ) && 'yes' === $atts['appear_animation'] ? 'qodef-appear-animation' : '';

			return implode( ' ', $holder_classes );
		}

        public function get_idem_data( $item_atts ) {
            $data = array();

            $data['data-arrow-skin'] = ! empty( $item_atts['item_arrow_style'] ) ? $item_atts['item_arrow_style'] : '';

            return $data;
        }
	}
}
