<?php
$link_url_meta  = get_post_meta( get_the_ID(), 'qodef_post_format_link', true );
$link_url       = ! empty( $link_url_meta ) ? $link_url_meta : get_the_permalink();
$link_text_meta = get_post_meta( get_the_ID(), 'qodef_post_format_link_text', true );

if ( ! empty( $link_url ) ) {
	$link_text = ! empty( $link_text_meta ) ? $link_text_meta : get_the_title();
	$title_tag = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h3';
	?>
	<div class="qodef-e-link">
    <div class="qodef-e-link-label">
        <?php esc_html_e('Link', 'kropp');?>
    </div>
		<<?php echo esc_attr( $title_tag ); ?> class="qodef-e-link-text">
            <span class="qodef-e-link-sign">
                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26">
                    <g transform="translate(-268 -1379)">
                        <rect width="26" height="2" transform="translate(268 1391)" fill="currentColor"/>
                        <rect width="26" height="2" transform="translate(282 1379) rotate(90)" fill="currentColor"/>
                    </g>
                </svg>
            </span>
            <?php echo esc_html( $link_text ); ?>
        </<?php echo esc_attr( $title_tag ); ?>>
        <div class="qodef-e-link-mark">
            <svg xmlns="http://www.w3.org/2000/svg" width="64.676" height="32.838" viewBox="0 0 64.676 32.838">
                <path d="M9.049,26.419a9.878,9.878,0,0,1,9.87-9.87H31.654V10.5H18.919a15.919,15.919,0,0,0,0,31.838H31.654V36.289H18.919A9.878,9.878,0,0,1,9.049,26.419ZM22.1,29.6h25.47V23.235H22.1ZM50.757,10.5H38.022v6.049H50.757a9.87,9.87,0,1,1,0,19.74H38.022v6.049H50.757a15.919,15.919,0,1,0,0-31.838Z" transform="translate(-2.5 -10)" fill="none" stroke="currentColor" stroke-width="1"/>
            </svg>
        </div>
		<a itemprop="url" class="qodef-e-link-url" href="<?php echo esc_url( $link_url ); ?>" target="_blank"></a>
	</div>
<?php } ?>
