<?php

if ( ! function_exists( 'kropp_core_add_general_page_meta_box' ) ) {
	/**
	 * Function that add general meta box options for this module
	 *
	 * @param object $page
	 */
	function kropp_core_add_general_page_meta_box( $page ) {

		$general_tab = $page->add_tab_element(
			array(
				'name'        => 'tab-page',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Page Settings', 'kropp-core' ),
				'description' => esc_html__( 'General page layout settings', 'kropp-core' ),
			)
		);

        $general_tab->add_field_element(
            array(
                'field_type'  => 'select',
                'name'        => 'qodef_page_content_skin',
                'title'       => esc_html__( 'Page Skin', 'kropp-core' ),
                'description' => esc_html__( 'Change specific page element to white color when they are on dark background.', 'kropp-core' ),
                'options'     => array(
                    ''      => esc_html__( 'Default', 'kropp-core' ),
                    'dark'  => esc_html__( 'Dark', 'kropp-core' ),
                    'light' => esc_html__( 'Light', 'kropp-core' ),
                ),
            )
        );

        $general_tab->add_field_element(
            array(
                'field_type'  => 'color',
                'name'        => 'qodef_main_color',
                'title'       => esc_html__( 'Main Color', 'kropp-core' ),
                'description' => esc_html__( 'Choose the most dominant theme color', 'kropp-core' ),
            )
        );

		$general_tab->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_page_background_color',
				'title'       => esc_html__( 'Page Background Color', 'kropp-core' ),
				'description' => esc_html__( 'Set background color', 'kropp-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_page_background_image',
				'title'       => esc_html__( 'Page Background Image', 'kropp-core' ),
				'description' => esc_html__( 'Set background image', 'kropp-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_repeat',
				'title'       => esc_html__( 'Page Background Image Repeat', 'kropp-core' ),
				'description' => esc_html__( 'Set background image repeat', 'kropp-core' ),
				'options'     => array(
					''          => esc_html__( 'Default', 'kropp-core' ),
					'no-repeat' => esc_html__( 'No Repeat', 'kropp-core' ),
					'repeat'    => esc_html__( 'Repeat', 'kropp-core' ),
					'repeat-x'  => esc_html__( 'Repeat-x', 'kropp-core' ),
					'repeat-y'  => esc_html__( 'Repeat-y', 'kropp-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_size',
				'title'       => esc_html__( 'Page Background Image Size', 'kropp-core' ),
				'description' => esc_html__( 'Set background image size', 'kropp-core' ),
				'options'     => array(
					''        => esc_html__( 'Default', 'kropp-core' ),
					'contain' => esc_html__( 'Contain', 'kropp-core' ),
					'cover'   => esc_html__( 'Cover', 'kropp-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_attachment',
				'title'       => esc_html__( 'Page Background Image Attachment', 'kropp-core' ),
				'description' => esc_html__( 'Set background image attachment', 'kropp-core' ),
				'options'     => array(
					''       => esc_html__( 'Default', 'kropp-core' ),
					'fixed'  => esc_html__( 'Fixed', 'kropp-core' ),
					'scroll' => esc_html__( 'Scroll', 'kropp-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding',
				'title'       => esc_html__( 'Page Content Padding', 'kropp-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'kropp-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding_mobile',
				'title'       => esc_html__( 'Page Content Padding Mobile', 'kropp-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'kropp-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_boxed',
				'title'         => esc_html__( 'Boxed Layout', 'kropp-core' ),
				'description'   => esc_html__( 'Set boxed layout', 'kropp-core' ),
				'default_value' => '',
				'options'       => kropp_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$boxed_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_boxed_section',
				'title'      => esc_html__( 'Boxed Layout Section', 'kropp-core' ),
				'dependency' => array(
					'hide' => array(
						'qodef_boxed' => array(
							'values'        => 'no',
							'default_value' => '',
						),
					),
				),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_boxed_background_color',
				'title'       => esc_html__( 'Boxed Background Color', 'kropp-core' ),
				'description' => esc_html__( 'Set boxed background color', 'kropp-core' ),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_boxed_background_pattern',
				'title'       => esc_html__( 'Boxed Background Pattern', 'kropp-core' ),
				'description' => esc_html__( 'Set boxed background pattern', 'kropp-core' ),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_boxed_background_pattern_behavior',
				'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'kropp-core' ),
				'description' => esc_html__( 'Set boxed background pattern behavior', 'kropp-core' ),
				'options'     => array(
					''       => esc_html__( 'Default', 'kropp-core' ),
					'fixed'  => esc_html__( 'Fixed', 'kropp-core' ),
					'scroll' => esc_html__( 'Scroll', 'kropp-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_passepartout',
				'title'         => esc_html__( 'Passepartout', 'kropp-core' ),
				'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'kropp-core' ),
				'default_value' => '',
				'options'       => kropp_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$passepartout_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_passepartout_section',
				'dependency' => array(
					'hide' => array(
						'qodef_passepartout' => array(
							'values'        => 'no',
							'default_value' => '',
						),
					),
				),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_passepartout_color',
				'title'       => esc_html__( 'Passepartout Color', 'kropp-core' ),
				'description' => esc_html__( 'Choose background color for passepartout', 'kropp-core' ),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_passepartout_image',
				'title'       => esc_html__( 'Passepartout Background Image', 'kropp-core' ),
				'description' => esc_html__( 'Set background image for passepartout', 'kropp-core' ),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size',
				'title'       => esc_html__( 'Passepartout Size', 'kropp-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout', 'kropp-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'kropp-core' ),
				),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size_responsive',
				'title'       => esc_html__( 'Passepartout Responsive Size', 'kropp-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'kropp-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'kropp-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_content_width',
				'title'       => esc_html__( 'Initial Width of Content', 'kropp-core' ),
				'description' => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'kropp-core' ),
				'options'     => kropp_core_get_select_type_options_pool( 'content_width' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'yesno',
				'default_value' => 'no',
				'name'          => 'qodef_content_behind_header',
				'title'         => esc_html__( 'Always put content behind header', 'kropp-core' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'kropp-core' ),
			)
		);

		// Hook to include additional options after module options
		do_action( 'kropp_core_action_after_general_page_meta_box_map', $general_tab );
	}

	add_action( 'kropp_core_action_after_general_meta_box_map', 'kropp_core_add_general_page_meta_box', 9 );
}

if ( ! function_exists( 'kropp_core_add_general_page_meta_box_callback' ) ) {
	/**
	 * Function that set current meta box callback as general callback functions
	 *
	 * @param array $callbacks
	 *
	 * @return array
	 */
	function kropp_core_add_general_page_meta_box_callback( $callbacks ) {
		$callbacks['page'] = 'kropp_core_add_general_page_meta_box';

		return $callbacks;
	}

	add_filter( 'kropp_core_filter_general_meta_box_callbacks', 'kropp_core_add_general_page_meta_box_callback' );
}
