(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.kropp_core_image_with_text = {};

	$( window ).on(
		'load',
		() => {
			qodefImageWithText.init();
		}
	);

	const qodefImageWithText = {
		init () {
			this.shortcode = $('.qodef-image-with-text');

			if ( this.shortcode.length ) {
				this.shortcode.each(
					( index, element ) => {
						const $thisShortcode = $( element );

						if ( $thisShortcode.hasClass('qodef-appear-animation--yes') ) {
							qodefImageWithText.appearAnimation( $thisShortcode );
						}
					}
				);
			}
		},
		appearAnimation ( $holder ) {
			if ( $holder.hasClass('qodef-wait-for-trigger') ) {
				const randomDelay = Math.floor(Math.random() * 1000) + 1;
				const delay       = $holder.data('appearing-delay');

				const interval = setInterval(
					() => {
						if ( qodef.body.hasClass('qodef-spinner--end') ) {
							setTimeout(
								() => {
									$holder.addClass( 'qodef--appeared' );
								}, randomDelay + delay
							);
							clearInterval(interval);
						}
					}, 100
				);
			} else {
				qodefCore.qodefIsInViewport.check(
					$holder,
					() => {
						$holder.addClass( 'qodef--appeared' );
					}
				);
			}
		}
	};

	qodefCore.shortcodes.kropp_core_image_with_text.qodefImageWithText = qodefImageWithText;
	qodefCore.shortcodes.kropp_core_image_with_text.qodefMagnificPopup = qodef.qodefMagnificPopup;
	qodefCore.shortcodes.kropp_core_image_with_text.qodefHoverTrigger = qodef.qodefHoverTrigger.init('.qodef-image-with-text .qodef-m-image > a, .qodef-image-with-text .qodef-m-title a', '.qodef-image-with-text');

})( jQuery );



/*(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.kropp_core_image_with_text                    = {};
	qodefCore.shortcodes.kropp_core_image_with_text.qodefMagnificPopup = qodef.qodefMagnificPopup;

	$( document ).ready(
		function () {
			/!* hovered class on image & read more btn *!/
			qodef.qodefHoverTrigger.init('.qodef-image-with-text .qodef-m-image > a, .qodef-image-with-text .qodef-m-title a', '.qodef-image-with-text');
		}
	);

})( jQuery );*/
