<?php

if ( ! function_exists( 'kropp_core_add_rest_api_bmi_calculator_global_variables' ) ) {
	/**
	 * Extend main rest api variables with new case
	 *
	 * @param array $global - list of variables
	 * @param string $namespace - rest namespace url
	 *
	 * @return array
	 */
	function kropp_core_add_rest_api_bmi_calculator_global_variables( $global, $namespace ) {
		$global['bmiCalculatorRestRoute'] = $namespace . '/bmi-calculate';

		return $global;
	}

	add_filter( 'kropp_filter_rest_api_global_variables', 'kropp_core_add_rest_api_bmi_calculator_global_variables', 10, 2 );
}

if ( ! function_exists( 'kropp_core_add_rest_api_bmi_calculator_route' ) ) {
	/**
	 * Extend main rest api routes with new case
	 *
	 * @param array $routes - list of rest routes
	 *
	 * @return array
	 */
	function kropp_core_add_rest_api_bmi_calculator_route( $routes ) {
		$routes['bmi-calculate'] = array(
			'route'    => 'bmi-calculate',
			'methods'  => WP_REST_Server::CREATABLE,
			'callback' => 'kropp_core_bmi_calculate',
			'args'     => array(
				'options' => array(
					'required'          => true,
					'validate_callback' => function ( $param, $request, $key ) {
						// Simple solution for validation can be 'is_array' value instead of callback function
						return is_array( $param ) ? $param : (array) $param;
					},
					'description'       => esc_html__( 'Options data is array with reaction and id values', 'kropp-core' ),
				),
			),
		);

		return $routes;
	}

	add_filter( 'kropp_filter_rest_api_routes', 'kropp_core_add_rest_api_bmi_calculator_route' );
}

if ( ! function_exists( 'kropp_core_get_ajax_status' ) ) {
	/**
	 * Function that return status from ajax functions
	 *
	 * @param string $status - success or error
	 * @param string $message - ajax message value
	 * @param string|array $data - returned value
	 * @param string $redirect - url address
	 */
	function kropp_core_get_ajax_status( $status, $message, $data = null, $redirect = '' ) {
		$response = array(
			'status'   => esc_attr( $status ),
			'message'  => $message,
			'data'     => $data,
			'redirect' => $redirect,
		);

		$response = apply_filters( 'kropp_core_filter_ajax_status', $response );

		$output = json_encode( $response );

		exit( $output );
	}
}

if ( ! function_exists( 'kropp_core_bmi_calculate' ) ) {
	function kropp_core_bmi_calculate() {

		if ( ! isset( $_POST ) || empty( $_POST ) ) {
			qode_framework_get_ajax_status( 'error', esc_html__( 'You are not authorized.', 'kropp-core' ) );
		} else {
			parse_str( $_POST['options'], $form_fields );

			if ( ! is_numeric( $form_fields['height'] ) || empty( $form_fields['height'] ) || ! is_numeric( $form_fields['weight'] ) || empty( $form_fields['weight'] ) || ! is_numeric( $form_fields['age'] ) || empty( $form_fields['age'] ) ) {
				qode_framework_get_ajax_status( 'invalid', esc_html__( 'Please enter valid numeric values for height, weight and age.', 'kropp-core' ) );
			} else {
				$bmi       = round( $form_fields['weight'] / pow( $form_fields['height'] / 100, 2 ), 2 );
				$bmi_label = '';
				$bmr       = 0;
				$tdee      = 0;

				if ( $bmi < 18.5 ) {
					$bmi_label = esc_html__( 'underweight', 'kropp-core' );
				} elseif ( $bmi >= 18.5 && $bmi < 25 ) {
					$bmi_label = esc_html__( 'healthy', 'kropp-core' );
				} elseif ( $bmi >= 25 && $bmi < 30 ) {
					$bmi_label = esc_html__( 'overweight', 'kropp-core' );
				} elseif ( $bmi >= 30 ) {
					$bmi_label = esc_html__( 'obese', 'kropp-core' );
				}

				$message = '<span class="qodef-info-icon"><svg xmlns="http://www.w3.org/2000/svg" width="29.397" height="82" viewBox="0 0 29.397 82">
  <g transform="translate(-194.132 -71.207)">
    <path d="M216.814,189.01V134.82a18.691,18.691,0,0,1,.736,2.353,58.6,58.6,0,0,1,1.29,13.812c0,2.517-.083,5.326-.266,8.453a2.345,2.345,0,0,0,2.2,2.477c.047,0,.093,0,.139,0a2.345,2.345,0,0,0,2.339-2.208c.187-3.207.274-6.106.274-8.726-.009-8.759-.941-14.4-2.45-18.13a11.192,11.192,0,0,0-2.833-4.285,6.1,6.1,0,0,0-2.929-1.457,2.26,2.26,0,0,0-.768-.136H203.226a2.257,2.257,0,0,0-.695.11,6.055,6.055,0,0,0-3.117,1.483c-1.717,1.527-2.948,3.9-3.852,7.462a63.022,63.022,0,0,0-1.431,14.952c0,2.62.086,5.52.274,8.727a2.345,2.345,0,0,0,2.338,2.207q.069,0,.139,0a2.344,2.344,0,0,0,2.2-2.478c-.183-3.127-.266-5.936-.266-8.453-.009-8.407.956-13.577,2.1-16.358.013-.03.025-.057.037-.087v54.47a3.624,3.624,0,0,0,7.247,0V156.8h1.358V189.01a3.623,3.623,0,0,0,7.247,0Z" transform="translate(0 -39.427)"/>
    <circle cx="6.594" cy="6.594" r="6.594" transform="translate(202.294 71.207)"/>
  </g>
</svg>
</span>';
				$message .= '<div class="qodef-info-text">';
				$message .= '<h6 class="qodef-m-title">' . esc_html__( 'You are ', 'kropp-core' ) . $bmi_label . '!' . '</h6>';
				$message .= '<p>';
				$message .= ' ' . esc_html__( 'Your BMI is ', 'kropp-core' ) . $bmi . '.';

				if ( ! empty( $form_fields['gender'] ) && in_array( $form_fields['gender'], array( 'male', 'female' ), true ) ) {
					switch ( $form_fields['gender'] ) {
						case 'male':
							$bmr = 10 * $form_fields['weight'] + 6.25 * $form_fields['height'] - 5 * $form_fields['age'] + 5;
							break;
						case 'female':
							$bmr = 10 * $form_fields['weight'] + 6.25 * $form_fields['height'] - 5 * $form_fields['age'] - 161;
							break;
					}
					$message .= ' ' . esc_html__( 'BMR ', 'kropp-core' ) . $bmr . esc_html__( 'kcal/day', 'kropp-core' );
				}

				if ( ! empty( $form_fields['activity_level'] ) && in_array( $form_fields['activity_level'], array( 'little', 'light', 'moderate', 'heavy', 'very_heavy' ), true ) ) {
					switch ( $form_fields['activity_level'] ) {
						case 'little':
							$tdee = $bmr * 1.2;
							break;
						case 'light':
							$tdee = $bmr * 1.375;
							break;
						case 'moderate':
							$tdee = $bmr * 1.55;
							break;
						case 'heavy':
							$tdee = $bmr * 1.725;
							break;
						case 'very_heavy':
							$tdee = $bmr * 1.9;
							break;
					}
					$message .= ', ' . esc_html__( 'and BMR w/Activity Factor ', 'kropp-core' ) . $tdee . esc_html__( 'kcal/day', 'kropp-core' );
				}

				$message .= '</p></div>';
				$message .= '<span class="qodef-info-icon-close"><svg xmlns="http://www.w3.org/2000/svg" width="17.16" height="17.16" viewBox="0 0 17.16 17.16">
  <g transform="translate(-1577.086 -5217.086)">
    <line y1="14.332" x2="14.332" transform="translate(1578.5 5218.5)" fill="none" stroke="#2c2c2c" stroke-linecap="round" stroke-width="2"/>
    <line x1="14.332" y1="14.332" transform="translate(1578.5 5218.5)" fill="none" stroke="#2c2c2c" stroke-linecap="round" stroke-width="2"/>
  </g>
</svg></span>';

				kropp_core_get_ajax_status( 'success', $message );
			}
		}
	}
}
