<?php
$title_tag            = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h2';
$title                = get_the_title();
$line_break_positions = get_post_meta( get_the_ID(), 'qodef_team_member_title_line_break_positions', true );

if ( ! empty( $title ) && ! empty( $line_break_positions ) ) {
    $split_title          = explode( ' ', $title );
    $line_break_positions = explode( ',', str_replace( ' ', '', $line_break_positions ) );

    foreach ( $line_break_positions as $position ) {
        $position = intval( $position );
        if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
            $split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
        }
    }

    $title = implode( ' ', $split_title );
}
?>
<<?php echo esc_attr( $title_tag ); ?> itemprop="name" class="qodef-e-title entry-title" <?php qode_framework_inline_style( $this_shortcode->get_title_styles( $params ) ); ?>>
	<?php if ( $has_single ) { ?>
		<a itemprop="url" class="qodef-e-title-link" href="<?php the_permalink(); ?>">
	<?php } ?>
        <?php echo qode_framework_wp_kses_html( 'content', $title ); ?>
	<?php if ( $has_single ) { ?>
		</a>
	<?php } ?>
</<?php echo esc_attr( $title_tag ); ?>>
