<?php

if ( ! function_exists( 'kropp_core_add_outlined_title_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function kropp_core_add_outlined_title_shortcode( $shortcodes ) {
		$shortcodes[] = 'KroppCore_Outlined_Title_Shortcode';

		return $shortcodes;
	}

	add_filter( 'kropp_core_filter_register_shortcodes', 'kropp_core_add_outlined_title_shortcode' );
}

if ( class_exists( 'KroppCore_Shortcode' ) ) {
	class KroppCore_Outlined_Title_Shortcode extends KroppCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( KROPP_CORE_SHORTCODES_URL_PATH . '/outlined-title' );
			$this->set_base( 'kropp_core_outlined_title' );
			$this->set_name( esc_html__( 'Outlined Title', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds outlined title element', 'kropp-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'kropp-core' ),
					'default_value' => esc_html__( 'Title Text', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'title_outline_color',
                    'title'      => esc_html__( 'Title Outline Color', 'kropp-core' ),
                    'group'      => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_alignment',
					'title'      => esc_html__( 'Content Alignment', 'kropp-core' ),
					'options'    => array(
						''       => esc_html__( 'Default', 'kropp-core' ),
						'left'   => esc_html__( 'Left', 'kropp-core' ),
						'center' => esc_html__( 'Center', 'kropp-core' ),
						'right'  => esc_html__( 'Right', 'kropp-core' ),
					),
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'enable_appear',
                    'title'         => esc_html__( 'Appear Animation', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                )
            );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			// fixed atts
            $atts['title_tag'] = 'p';

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
            $atts['title_classes']  = $this->get_title_classes( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );

			return kropp_core_get_template_part( 'shortcodes/outlined-title', 'templates/outlined-title', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-outlined-title';
			$holder_classes[] = ! empty( $atts['content_alignment'] ) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';

			return implode( ' ', $holder_classes );
		}

        private function get_title_classes( $atts ) {
            $title_classes = array();

            $title_classes[] = 'qodef-m-title';
            $title_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--custom-chars-splitting-animation' : '';

            return implode( ' ', $title_classes );
        }

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['title_outline_color'] ) ) {
				$styles[] = '-webkit-text-stroke-color: ' . $atts['title_outline_color'];
			}

			return $styles;
		}
	}
}
