(function ( $ ) {
    'use strict';

    qodefCore.shortcodes.kropp_core_custom_font = {};

    $( window ).on(
        'load',
        () => {
            qodefCustomFont.init();
        }
    );

    const qodefCustomFont = {
        init () {
            this.shortcode = $('.qodef-custom-font');

            if ( this.shortcode.length ) {
                this.shortcode.each(
                    ( index, element ) => {
                        const $thisShortcode = $( element );

                        if ( $thisShortcode.hasClass('qodef-appear-animation--yes') ) {
                            qodefCustomFont.appearAnimation( $thisShortcode );
                        }
                    }
                );
            }
        },
        appearAnimation ( $holder ) {
            if ( $holder.hasClass('qodef-wait-for-trigger') ) {
                const interval = setInterval(
                    () => {
                        if ( qodef.body.hasClass('qodef-spinner--end') ) {
                            setTimeout(
                                () => {
                                    $holder.addClass( 'qodef--appeared' );
                                }, 100
                            );
                            clearInterval(interval);
                        }
                    }, 100
                );
            } else {
                qodefCore.qodefIsInViewport.check(
                    $holder,
                    () => {
                        $holder.addClass( 'qodef--appeared' );
                    }
                );
            }
        }
    };

    qodefCore.shortcodes.kropp_core_custom_font.qodefCustomFont = qodefCustomFont;

})( jQuery );
