<?php

if ( ! function_exists( 'kropp_core_add_button_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function kropp_core_add_button_widget( $widgets ) {
		$widgets[] = 'KroppCore_Button_Widget';

		return $widgets;
	}

	add_filter( 'kropp_core_filter_register_widgets', 'kropp_core_add_button_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class KroppCore_Button_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'kropp_core_button',
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'kropp_core_button' );
				$this->set_name( esc_html__( 'Kropp Button', 'kropp-core' ) );
				$this->set_description( esc_html__( 'Add a button element into widget areas', 'kropp-core' ) );
			}
		}

		public function render( $atts ) {
			echo KroppCore_Button_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
