<?php

if ( ! function_exists( 'kropp_core_add_testimonials_meta_box' ) ) {
	/**
	 * Function that adds fields for testimonials
	 */
	function kropp_core_add_testimonials_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'testimonials' ),
				'type'  => 'meta',
				'slug'  => 'testimonials',
				'title' => esc_html__( 'Testimonials Parameters', 'kropp-core' ),
			)
		);

		if ( $page ) {
            $page->add_field_element(
                array(
                    'field_type' => 'text',
                    'name'       => 'qodef_testimonials_title_background_text',
                    'title'      => esc_html__( 'Title Background Text', 'kropp-core' ),
                )
            );

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_title',
					'title'      => esc_html__( 'Title', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_testimonials_text',
					'title'      => esc_html__( 'Text', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_author',
					'title'      => esc_html__( 'Author', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_author_job',
					'title'      => esc_html__( 'Author Job Title', 'kropp-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'kropp_core_action_after_testimonials_meta_box_map', $page );
		}
	}

	add_action( 'kropp_core_action_default_meta_boxes_init', 'kropp_core_add_testimonials_meta_box' );
}
