<?php

if ( ! function_exists( 'kropp_core_add_standard_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function kropp_core_add_standard_header_meta( $page ) {
		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_standard_header_section',
				'title'      => esc_html__( 'Standard Header', 'kropp-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => array( '', 'standard' ),
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'kropp-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'kropp-core' ),
				'default_value' => '',
				'options'       => kropp_core_get_select_type_options_pool( 'no_yes' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_height',
				'title'       => esc_html__( 'Header Height', 'kropp-core' ),
				'description' => esc_html__( 'Enter header height', 'kropp-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'kropp-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'kropp-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'kropp-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'kropp-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'kropp-core' ),
				'description' => esc_html__( 'Enter header background color', 'kropp-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'kropp-core' ),
				'description' => esc_html__( 'Enter header border color', 'kropp-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'kropp-core' ),
				'description' => esc_html__( 'Enter header border width size', 'kropp-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'kropp-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_standard_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'kropp-core' ),
				'description' => esc_html__( 'Choose header border style', 'kropp-core' ),
				'options'     => kropp_core_get_select_type_options_pool( 'border_style' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_menu_position',
				'title'         => esc_html__( 'Menu position', 'kropp-core' ),
				'default_value' => '',
				'options'       => array(
					''       => esc_html__( 'Default', 'kropp-core' ),
					'left'   => esc_html__( 'Left', 'kropp-core' ),
					'center' => esc_html__( 'Center', 'kropp-core' ),
					'right'  => esc_html__( 'Right', 'kropp-core' ),
				),
			)
		);
	}

	add_action( 'kropp_core_action_after_page_header_meta_map', 'kropp_core_add_standard_header_meta' );
}
