<?php

if ( ! function_exists( 'kropp_core_add_social_share_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function kropp_core_add_social_share_widget( $widgets ) {
		$widgets[] = 'KroppCore_Social_Share_Widget';

		return $widgets;
	}

	add_filter( 'kropp_core_filter_register_widgets', 'kropp_core_add_social_share_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class KroppCore_Social_Share_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'kropp_core_social_share',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'kropp_core_social_share' );
				$this->set_name( esc_html__( 'Kropp Social Share', 'kropp-core' ) );
				$this->set_description( esc_html__( 'Add a social share element into widget areas', 'kropp-core' ) );
			}
		}

		public function render( $atts ) {
			echo KroppCore_Social_Share_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
