<?php

if ( ! function_exists( 'kropp_core_add_icon_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function kropp_core_add_icon_widget( $widgets ) {
		$widgets[] = 'KroppCore_Icon_Widget';

		return $widgets;
	}

	add_filter( 'kropp_core_filter_register_widgets', 'kropp_core_add_icon_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class KroppCore_Icon_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'kropp_core_icon',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'kropp_core_icon' );
				$this->set_name( esc_html__( 'Kropp Icon', 'kropp-core' ) );
				$this->set_description( esc_html__( 'Add a icon element into widget areas', 'kropp-core' ) );
			}
		}

		public function render( $atts ) {
			echo KroppCore_Icon_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
