(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.kropp_core_bmi_calculator = {};

	$( document ).ready(
		function () {
			qodefBMIAccordion.init();
		}
	);

	var qodefBMIAccordion = {
		init: function () {
			this.holder = $( '.qodef-bmi-form' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $thisHolder         = $( this ),
							$notificationHolder = $thisHolder.parents( '.qodef-bmi-calculator' ).find( '.qodef-bmi-notification' );

						qodefBMIAccordion.initSelect2( $thisHolder );
						qodefBMIAccordion.calculate( $thisHolder, $notificationHolder );
					}
				);
			}
		},
		initSelect2: function( $thisHolder ) {
			var $selects = $thisHolder.find( '.qodef-select2' );

			if ( $selects.length ) {
				$selects.each(
					function () {

						$( this ).select2(
							{
								minimumResultsForSearch: -1,
								dropdownCssClass: 'qodef-bmi-selection',
							}
						);
					}
				);
			}
		},
		calculate: function( $thisHolder, $notificationHolder ) {
			$thisHolder.submit(
				function (e) {
					e.preventDefault();

					$notificationHolder.hide();
					$notificationHolder.html( '' );
					$notificationHolder.removeClass( 'qodef-error qodef-sucess' );

					$.ajax(
						{
							type: 'POST',
							url: qodefGlobal.vars.restUrl + qodefGlobal.vars.bmiCalculatorRestRoute,
							data: {
								options: $thisHolder.serialize(),
							},
							beforeSend: function ( request ) {
								request.setRequestHeader( 'X-WP-Nonce', qodefGlobal.vars.restNonce );
							},
							success: function ( response ) {
								if ( response.status === 'success' ) {
									$notificationHolder.addClass( 'qodef-sucess' );
									$notificationHolder.html( response.message );
									$notificationHolder.show();
								} else if ( response.status === 'invalid' ) {
									$notificationHolder.addClass( 'qodef-error' );
									$notificationHolder.html( response.message );
									$notificationHolder.show();
								}

								var $closeInfoButton = $notificationHolder.find('.qodef-info-icon-close');

								if ( $closeInfoButton.length ) {
									$closeInfoButton.on(
										'tap click',
										function ( e ) {
											e.preventDefault();

											$notificationHolder.hide();
											$notificationHolder.html( '' );
											$notificationHolder.removeClass( 'qodef-error qodef-sucess' );
										}
									);
								}
							},
						}
					);
				}
			);
		},
	};

	qodefCore.shortcodes.kropp_core_bmi_calculator.qodefBMIAccordion = qodefBMIAccordion;

})( jQuery );
