<?php

if ( ! function_exists( 'kropp_core_add_timetable_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function kropp_core_add_timetable_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => KROPP_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'timetable',
				'icon'        => 'fa fa-book',
				'title'       => esc_html__( 'Timetable', 'kropp-core' ),
				'description' => esc_html__( 'Global Timetable Options', 'kropp-core' ),
			)
		);

		if ( $page ) {

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_timetable_predefined_style',
					'title'         => esc_html__( 'Enable Predefined Style', 'kropp-core' ),
					'description'   => esc_html__( 'Enabling this option will set predefined style for timetable plugin', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'yes',
				)
			);

            $page->add_field_element(
                array(
                    'field_type'    => 'select',
                    'name'          => 'qodef_timetable_single_sidebar_layout',
                    'title'         => esc_html__( 'Sidebar Layout', 'kropp-core' ),
                    'description'   => esc_html__( 'Choose default sidebar layout for timetable single pages', 'kropp-core' ),
                    'default_value' => 'no-sidebar',
                    'options'       => kropp_core_get_select_type_options_pool( 'sidebar_layouts', false )
                )
            );

            $custom_sidebars = kropp_core_get_custom_sidebars();
            if ( ! empty( $custom_sidebars ) && count( $custom_sidebars ) > 1 ) {
                $page->add_field_element(
                    array(
                        'field_type'  => 'select',
                        'name'        => 'qodef_timetable_single_custom_sidebar',
                        'title'       => esc_html__( 'Custom Sidebar', 'kropp-core' ),
                        'description' => esc_html__( 'Choose a custom sidebar to display on timetable single pages', 'kropp-core' ),
                        'options'     => $custom_sidebars
                    )
                );
            }

            $page->add_field_element(
                array(
                    'field_type'  => 'select',
                    'name'        => 'qodef_timetable_single_sidebar_grid_gutter',
                    'title'       => esc_html__( 'Set Grid Gutter', 'kropp-core' ),
                    'description' => esc_html__( 'Choose grid gutter size to set space between content and sidebar for blog single', 'kropp-core' ),
                    'options'     => kropp_core_get_select_type_options_pool( 'items_space' )
                )
            );

			// Hook to include additional options after module options
			do_action( 'kropp_core_action_after_timetable_options_map', $page );
		}
	}

	add_action( 'kropp_core_action_default_options_init', 'kropp_core_add_timetable_options', kropp_core_get_admin_options_map_position( 'timetable' ) );
}
