<?php

if ( ! function_exists( 'kropp_core_add_general_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function kropp_core_add_general_options( $page ) {

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_main_color',
					'title'       => esc_html__( 'Main Color', 'kropp-core' ),
					'description' => esc_html__( 'Choose the most dominant theme color', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_background_color',
					'title'       => esc_html__( 'Page Background Color', 'kropp-core' ),
					'description' => esc_html__( 'Set background color', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_page_background_image',
					'title'       => esc_html__( 'Page Background Image', 'kropp-core' ),
					'description' => esc_html__( 'Set background image', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_repeat',
					'title'       => esc_html__( 'Page Background Image Repeat', 'kropp-core' ),
					'description' => esc_html__( 'Set background image repeat', 'kropp-core' ),
					'options'     => array(
						''          => esc_html__( 'Default', 'kropp-core' ),
						'no-repeat' => esc_html__( 'No Repeat', 'kropp-core' ),
						'repeat'    => esc_html__( 'Repeat', 'kropp-core' ),
						'repeat-x'  => esc_html__( 'Repeat-x', 'kropp-core' ),
						'repeat-y'  => esc_html__( 'Repeat-y', 'kropp-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_size',
					'title'       => esc_html__( 'Page Background Image Size', 'kropp-core' ),
					'description' => esc_html__( 'Set background image size', 'kropp-core' ),
					'options'     => array(
						''        => esc_html__( 'Default', 'kropp-core' ),
						'contain' => esc_html__( 'Contain', 'kropp-core' ),
						'cover'   => esc_html__( 'Cover', 'kropp-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_attachment',
					'title'       => esc_html__( 'Page Background Image Attachment', 'kropp-core' ),
					'description' => esc_html__( 'Set background image attachment', 'kropp-core' ),
					'options'     => array(
						''       => esc_html__( 'Default', 'kropp-core' ),
						'fixed'  => esc_html__( 'Fixed', 'kropp-core' ),
						'scroll' => esc_html__( 'Scroll', 'kropp-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding',
					'title'       => esc_html__( 'Page Content Padding', 'kropp-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding_mobile',
					'title'       => esc_html__( 'Page Content Padding Mobile', 'kropp-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed',
					'title'         => esc_html__( 'Boxed Layout', 'kropp-core' ),
					'description'   => esc_html__( 'Set boxed layout', 'kropp-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section = $page->add_section_element(
				array(
					'name'       => 'qodef_boxed_section',
					'title'      => esc_html__( 'Boxed Layout Section', 'kropp-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_boxed' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_boxed_background_color',
					'title'       => esc_html__( 'Boxed Background Color', 'kropp-core' ),
					'description' => esc_html__( 'Set boxed background color', 'kropp-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_boxed_background_pattern',
					'title'       => esc_html__( 'Boxed Background Pattern', 'kropp-core' ),
					'description' => esc_html__( 'Set boxed background pattern', 'kropp-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_boxed_background_pattern_behavior',
					'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'kropp-core' ),
					'description' => esc_html__( 'Set boxed background pattern behavior', 'kropp-core' ),
					'options'     => array(
						'fixed'  => esc_html__( 'Fixed', 'kropp-core' ),
						'scroll' => esc_html__( 'Scroll', 'kropp-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_passepartout',
					'title'         => esc_html__( 'Passepartout', 'kropp-core' ),
					'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'kropp-core' ),
					'default_value' => 'no',
				)
			);

			$passepartout_section = $page->add_section_element(
				array(
					'name'       => 'qodef_passepartout_section',
					'title'      => esc_html__( 'Passepartout Section', 'kropp-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_passepartout' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_passepartout_color',
					'title'       => esc_html__( 'Passepartout Color', 'kropp-core' ),
					'description' => esc_html__( 'Choose background color for passepartout', 'kropp-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_passepartout_image',
					'title'       => esc_html__( 'Passepartout Background Image', 'kropp-core' ),
					'description' => esc_html__( 'Set background image for passepartout', 'kropp-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size',
					'title'       => esc_html__( 'Passepartout Size', 'kropp-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout', 'kropp-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'kropp-core' ),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size_responsive',
					'title'       => esc_html__( 'Passepartout Responsive Size', 'kropp-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'kropp-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'kropp-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_content_width',
					'title'         => esc_html__( 'Initial Width of Content', 'kropp-core' ),
					'description'   => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'content_width', false ),
					'default_value' => '1300',
				)
			);

			// Hook to include additional options after module options
			do_action( 'kropp_core_action_after_general_options_map', $page );

			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_custom_js',
					'title'       => esc_html__( 'Custom JS', 'kropp-core' ),
					'description' => esc_html__( 'Enter your custom JavaScript here', 'kropp-core' ),
				)
			);
		}
	}

	add_action( 'kropp_core_action_default_options_init', 'kropp_core_add_general_options', kropp_core_get_admin_options_map_position( 'general' ) );
}
