(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSearchBelowHeader.init();
		}
	);

	var qodefSearchBelowHeader = {
		init: function () {
			var $searchOpener = $( 'a.qodef-search-opener' ),
				$searchForm   = $( '.qodef-search-below-form' ),
				$searchClose  = $searchForm.find( '.qodef-m-close' );

			if ( $searchOpener.length && $searchForm.length ) {
				$searchOpener.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchBelowHeader.openBelowHeader( $searchForm );
					}
				);
				$searchClose.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchBelowHeader.closeBelowHeader( $searchForm );
					}
				);
			}
		},
		openBelowHeader: function ( $searchForm ) {
			qodefCore.body.addClass( 'qodef-below-search--opened qodef-below-search--fadein' );
			qodefCore.body.removeClass( 'qodef-below-search--fadeout' );

			setTimeout(
				function () {
					$searchForm.find( '.qodef-m-form-field' ).focus();
				},
				600
			);
		},
		closeBelowHeader: function ( $searchForm ) {
			qodefCore.body.removeClass( 'qodef-below-search--opened qodef-below-search--fadein' );
			qodefCore.body.addClass( 'qodef-below-search--fadeout' );

			setTimeout(
				function () {
					$searchForm.find( '.qodef-m-form-field' ).val( '' );
					$searchForm.find( '.qodef-m-form-field' ).blur();
					qodefCore.body.removeClass( 'qodef-below-search--fadeout' );
				},
				300
			);
		}
	};

})( jQuery );
