<?php

if ( ! function_exists( 'kropp_core_add_admin_user_options' ) ) {
	/**
	 * Function that add global user options
	 */
	function kropp_core_add_admin_user_options() {
		$qode_framework     = qode_framework_get_framework_root();
		$roles_social_scope = apply_filters( 'kropp_core_filter_role_social_array', array( 'administrator', 'author' ) );

		$page = $qode_framework->add_options_page(
			array(
				'scope' => $roles_social_scope,
				'type'  => 'user',
				'title' => esc_html__( 'Social Networks', 'kropp-core' ),
				'slug'  => 'admin-options',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_user_facebook',
					'title'       => esc_html__( 'Facebook', 'kropp-core' ),
					'description' => esc_html__( 'Enter user Facebook profile URL', 'kropp-core' ),
				)
			);

            $page->add_field_element(
                array(
                    'field_type'  => 'text',
                    'name'        => 'qodef_user_tiktok',
                    'title'       => esc_html__( 'Tiktok', 'kropp-core' ),
                    'description' => esc_html__( 'Enter user Tiktok profile URL', 'kropp-core' ),
                )
            );

            $page->add_field_element(
                array(
                    'field_type'  => 'text',
                    'name'        => 'qodef_user_youtube',
                    'title'       => esc_html__( 'Youtube', 'kropp-core' ),
                    'description' => esc_html__( 'Enter user Youtube profile URL', 'kropp-core' ),
                )
            );

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_user_instagram',
					'title'       => esc_html__( 'Instagram', 'kropp-core' ),
					'description' => esc_html__( 'Enter user Instagram profile URL', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_user_twitter',
					'title'       => esc_html__( 'Twitter', 'kropp-core' ),
					'description' => esc_html__( 'Enter user Twitter profile URL', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_user_linkedin',
					'title'       => esc_html__( 'LinkedIn', 'kropp-core' ),
					'description' => esc_html__( 'Enter user LinkedIn profile URL', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_user_pinterest',
					'title'       => esc_html__( 'Pinterest', 'kropp-core' ),
					'description' => esc_html__( 'Enter user Pinterest profile URL', 'kropp-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'kropp_core_action_after_admin_user_options_map', $page );
		}
	}

	add_action( 'kropp_core_action_register_role_custom_fields', 'kropp_core_add_admin_user_options' );
}
