<?php

if ( ! function_exists( 'kropp_core_add_testimonials_list_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function kropp_core_add_testimonials_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'KroppCore_Testimonials_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'kropp_core_filter_register_shortcodes', 'kropp_core_add_testimonials_list_shortcode' );
}

if ( class_exists( 'KroppCore_List_Shortcode' ) ) {
	class KroppCore_Testimonials_List_Shortcode extends KroppCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'testimonials' );
			$this->set_post_type_additional_taxonomies( array( 'testimonials-category' ) );
			$this->set_layouts( apply_filters( 'kropp_core_filter_testimonials_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'kropp_core_filter_testimonials_list_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( KROPP_CORE_CPT_URL_PATH . '/testimonials/shortcodes/testimonials-list' );
			$this->set_base( 'kropp_core_testimonials_list' );
			$this->set_name( esc_html__( 'Testimonials List', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of testimonials', 'kropp-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'predefined_slider_layout',
                    'title'         => esc_html__( 'Predefined Slider Layout', 'kropp-core' ),
                    'description'   => esc_html__( 'When enabled, Number of Columns and Columns Responsive options won\'t take effect.', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                    'dependency'    => array(
                        'show' => array(
                            'behavior' => array(
                                'values'        => 'slider',
                                'default_value' => 'columns',
                            ),
                        ),
                    ),
                )
            );
			$this->map_list_options(
				array(
					'exclude_behavior' => array( 'masonry', 'justified-gallery' ),
					'exclude_option'   => array( 'images_proportion' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'kropp-core' ),
					'options'    => kropp_core_get_select_type_options_pool( 'shortcode_skin' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'static_title',
					'title'      => esc_html__( 'Static Title', 'kropp-core' ),
					'group'      => esc_html__( 'Layout', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'static_title_tag',
					'title'         => esc_html__( 'Static Title Tag', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h1',
					'group'         => esc_html__( 'Layout', 'kropp-core' ),
				)
			);
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options(
			    array(
			        'layouts'                 => $this->get_layouts(),
                    'default_value_title_tag' => 'h2',
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'title_decoration',
                    'title'         => esc_html__( 'Title Decoration', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                    'group'         => esc_html__( 'Layout', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'show_title_background_text',
                    'title'         => esc_html__( 'Show Title Background Text', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                    'group'         => esc_html__( 'Layout', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'background_text_outline_color',
                    'title'      => esc_html__( 'Background Text Outline Color', 'kropp-core' ),
                    'group'      => esc_html__( 'Layout', 'kropp-core' ),
                )
            );
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'kropp_core_testimonials_list', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type'] = $this->get_post_type();

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['unique'] = rand( 0, 1000 );

			$atts['holder_classes']           = $this->get_holder_classes( $atts );
			$atts['item_classes']             = $this->get_item_classes( $atts );
            $atts['title_background_styles']  = $this->get_title_background_styles( $atts );
            $atts['title_background_classes'] = $this->get_title_background_classes( $atts );
			$atts['slider_attr']              = $this->get_slider_data( $atts, array( 'unique' => $atts['unique'] ) );
			$atts['query_result']             = new \WP_Query( kropp_core_get_query_params( $atts ) );

			$atts['this_shortcode'] = $this;

			return kropp_core_get_template_part( 'post-types/testimonials/shortcodes/testimonials-list', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-testimonials-list';
			$holder_classes[] = isset( $atts['skin'] ) && ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';
            $holder_classes[] = ! empty( $atts['title_decoration'] ) ? 'qodef-title-decoration--' . $atts['title_decoration'] : '';
            $holder_classes[] = ! empty( $atts['predefined_slider_layout'] ) ? 'qodef-predefined-slider-layout--' . $atts['predefined_slider_layout'] : '';
            $holder_classes[] = ! empty( $atts['show_title_background_text'] ) && 'yes' === $atts['show_title_background_text'] ? 'qodef-title-background-text--yes' : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}

        private function get_title_background_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['background_text_outline_color'] ) {
                $styles[] = '-webkit-text-stroke-color:' . $atts['background_text_outline_color'];
            }

            return $styles;
        }

        private function get_title_background_classes( $atts ) {
            $title_classes = array();

            $title_classes[] = 'qodef-m-title-background-text';
            $title_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--custom-chars-splitting-animation' : '';

            return implode( ' ', $title_classes );
        }
	}
}
