<?php

if ( ! function_exists( 'kropp_core_add_image_with_text_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function kropp_core_add_image_with_text_shortcode( $shortcodes ) {
		$shortcodes[] = 'KroppCore_Image_With_Text_Shortcode';

		return $shortcodes;
	}

	add_filter( 'kropp_core_filter_register_shortcodes', 'kropp_core_add_image_with_text_shortcode' );
}

if ( class_exists( 'KroppCore_Shortcode' ) ) {
	class KroppCore_Image_With_Text_Shortcode extends KroppCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'kropp_core_filter_image_with_text_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'kropp_core_filter_image_with_text_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( KROPP_CORE_SHORTCODES_URL_PATH . '/image-with-text' );
			$this->set_base( 'kropp_core_image_with_text' );
			$this->set_name( esc_html__( 'Image With Text', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds image with text element', 'kropp-core' ) );
			$this->set_scripts(
				array(
					'jquery-magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_necessary_styles(
				array(
					'magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'kropp-core' ),
				)
			);

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'show_arrow_cursor',
                    'title'         => esc_html__( 'Show Arrow Cursor', 'kropp-core' ),
                    'description'   => esc_html__( 'Enables big arrow cursor for Custom Link and Open Popup image actions.', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'arrow_pointer_on_hover',
                    'title'         => esc_html__( 'Show Arrow Pointer', 'kropp-core' ),
                    'description'   => esc_html__( 'Displays arrow pointer on top right corner.', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'always_show_arrow_cursor',
                    'title'         => esc_html__( 'Always Show Arrow Pointer', 'kropp-core' ),
                    'description'   => esc_html__( 'Arrow will be always displayed (not only on hover).', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'no',
                    'dependency' => array(
                        'show' => array(
                            'arrow_pointer_on_hover' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'show_big_arrow',
                    'title'         => esc_html__( 'Show Big Arrow', 'kropp-core' ),
                    'description'   => esc_html__( 'Enables big arrow hover.', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'no',
                    'dependency' => array(
                        'show' => array(
                            'arrow_pointer_on_hover' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'arrow_color',
                    'title'      => esc_html__( 'Arrow Color', 'kropp-core' ),
                    'group'      => esc_html__( 'Arrow Style', 'kropp-core' ),
                )
            );

			$options_map = kropp_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'kropp-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'image',
					'title'      => esc_html__( 'Image', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'image_border_on_hover',
                    'title'         => esc_html__( 'Show Image Border On Hover', 'kropp-core' ),
                    'description'   => esc_html__( 'Displays 1px border around image on hover.', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'no',
                )
            );
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'image_size',
					'title'       => esc_html__( 'Image Size', 'kropp-core' ),
					'description' => esc_html__( 'For predefined image sizes input thumbnail, medium, large or full. If you wish to set a custom image size, type in the desired image dimensions in pixels (e.g. 400x400).', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_action',
					'title'      => esc_html__( 'Image Action', 'kropp-core' ),
					'options'    => array(
						''            => esc_html__( 'No Action', 'kropp-core' ),
						'open-popup'  => esc_html__( 'Open Popup', 'kropp-core' ),
						'custom-link' => esc_html__( 'Custom Link', 'kropp-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Custom Link', 'kropp-core' ),
					'dependency' => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'dependency'    => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'kropp-core' ),
					'default_value' => esc_html__( 'Title Text', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h6',
					'group'         => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'kropp-core' ),
					'group'      => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'kropp-core' ),
					'group'      => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'kropp-core' ),
					'default_value' => esc_html__( 'Contrary to popular belief, Lorem Ipsum is not simply random text.', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'kropp-core' ),
					'group'      => esc_html__( 'Text Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'kropp-core' ),
					'group'      => esc_html__( 'Text Style', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'content_alignment',
                    'title'      => esc_html__( 'Content Alignment', 'kropp-core' ),
                    'options'    => array(
                        ''       => esc_html__( 'Default', 'kropp-core' ),
                        'left'   => esc_html__( 'Left', 'kropp-core' ),
                        'center' => esc_html__( 'Center', 'kropp-core' ),
                        'right'  => esc_html__( 'Right', 'kropp-core' ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'enable_appear_animation',
                    'title'         => esc_html__( 'Enable Appear Animation', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                    'group'         => esc_html__( 'Animation Options', 'kropp-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'wait_for_trigger',
                    'title'         => esc_html__( 'Wait For Trigger', 'kropp-core' ),
                    'description'   => esc_html__( 'Enabling this option will delay appear animation until external trigger is activated', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'no',
                    'dependency'    => array(
                        'show' => array(
                            'enable_appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                    'group'         => esc_html__( 'Animation Options', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'appear_animation_delay',
                    'title'      => esc_html__( 'Appear Animation Delay (ms)', 'kropp-core' ),
                    'group'      => esc_html__( 'Animation Options', 'kropp-core' ),
                    'dependency' => array(
                        'show' => array(
                            'enable_appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'kropp_core_image_with_text', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			$atts = $this->get_atts();

			if ( isset( $atts['image_action'] ) && 'open-popup' === $atts['image_action'] ) {
				wp_enqueue_style( 'magnific-popup' );
				wp_enqueue_script( 'jquery-magnific-popup' );
			}
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
            $atts['holder_data']    = $this->get_holder_data( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );
            $atts['arrow_styles']   = $this->get_arrow_styles( $atts );
			$atts['image_params']   = $this->generate_image_params( $atts );

			return kropp_core_get_template_part( 'shortcodes/image-with-text', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-image-with-text';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['show_arrow_cursor'] ) ? 'qodef-show-arrow-cursor--' . $atts['show_arrow_cursor'] : '';
			$holder_classes[] = ! empty( $atts['always_show_arrow_cursor'] ) ? 'qodef-always-show-arrow-cursor--' . $atts['always_show_arrow_cursor'] : '';
            $holder_classes[] = ! empty( $atts['content_alignment'] ) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';
            $holder_classes[] = ! empty( $atts['show_big_arrow'] ) ? 'qodef-show-big-arrow--' . $atts['show_big_arrow'] : '';
            $holder_classes[] = ! empty( $atts['arrow_pointer_on_hover'] ) ? 'qodef-arrow-pointer-on-hover--' . $atts['arrow_pointer_on_hover'] : '';
            $holder_classes[] = ! empty( $atts['image_border_on_hover'] ) ? 'qodef-image-border-on-hover--' . $atts['image_border_on_hover'] : '';
            $holder_classes[] = ! empty( $atts['enable_appear_animation'] ) ? 'qodef-appear-animation--' . $atts['enable_appear_animation'] : '';
            $holder_classes[] = ! empty( $atts['wait_for_trigger'] ) && 'yes' === $atts['wait_for_trigger'] ? 'qodef-wait-for-trigger' : '';

			return implode( ' ', $holder_classes );
		}

        private function get_holder_data( $atts ) {
            $data = array();

            $data['data-appearing-delay'] = ! empty( $atts['appear_animation_delay'] ) ? intval( $atts['appear_animation_delay'] ) : 0;

            return $data;
        }

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['title_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}

        private function get_arrow_styles( $atts ) {
            $styles = array();

            if ( ! empty( $atts['arrow_color'] ) ) {
                $styles[] = 'color: ' . $atts['arrow_color'];
            }

            return $styles;
        }

		private function generate_image_params( $atts ) {
			$image = array();

			if ( ! empty( $atts['image'] ) ) {
				$id = $atts['image'];

				if ( is_array( wp_get_attachment_image_src( $id ) ) ) {
					$image['image_id'] = intval( $id );
					$image_original    = wp_get_attachment_image_src( $id, 'full' );
					$image['url']      = $image_original[0];
					$image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );

					$image_size = trim( $atts['image_size'] );
					preg_match_all( '/\d+/', $image_size, $matches ); /* check if numeral width and height are entered */
					if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ), true ) ) {
						$image['image_size'] = $image_size;
					} elseif ( ! empty( $matches[0] ) ) {
						$image['image_size'] = array(
							$matches[0][0],
							$matches[0][1],
						);
					} else {
						$image['image_size'] = 'full';
					}
				}
			}

			return $image;
		}
	}
}
