<?php
$item_id               = get_the_ID();
$client_logo_source    = get_post_meta( $item_id, 'qodef_logo_source', true );
$client_svg_path       = get_post_meta( $item_id, 'qodef_logo_svg_path', true );
$client_svg_hover_path = get_post_meta( $item_id, 'qodef_logo_hover_svg_path', true );
$client_image          = get_post_meta( $item_id, 'qodef_logo_image', true );
$client_hover_image    = get_post_meta( $item_id, 'qodef_logo_hover_image', true );
$link                  = get_post_meta( $item_id, 'qodef_client_link', true );
$link_target           = get_post_meta( $item_id, 'qodef_client_link_target', true );
$link_target           = ! empty( $link_target ) ? $link_target : '_blank';

if ( ! empty( $client_logo_source ) ) { ?>

    <?php if ( 'image' === $client_logo_source ) { ?>
        <?php if ( ! empty( $client_image ) ) { ?>
            <div class="qodef-e-image">
                <?php if ( ! empty( $link ) ) { ?>
                    <a itemprop="url" href="<?php echo esc_url( $link ); ?>" target="<?php echo esc_attr( $link_target ); ?>">
                        <?php if ( ! empty( $show_arrow_pointer ) ) { ?>
                            <?php kropp_core_render_svg_icon('arrow-pointer-clients'); ?>
                        <?php } ?>
                <?php } ?>
                    <?php if ( ! empty( $client_image ) ) { ?>
                        <span class="qodef-e-logo">
                            <?php echo wp_get_attachment_image( $client_image, 'full' ); ?>
                        </span>
                    <?php } ?>
                    <?php if ( ! empty( $client_hover_image ) ) { ?>
                        <span class="qodef-e-hover-logo">
                            <?php echo wp_get_attachment_image( $client_hover_image, 'full' ); ?>
                        </span>
                    <?php } ?>
                <?php if ( ! empty( $link ) ) { ?>
                    </a>
                <?php } ?>
            </div>
        <?php } ?>
    <?php } elseif ( 'svg-path' === $client_logo_source ) { ?>
        <?php if ( ! empty( $client_svg_path ) ) { ?>
            <div class="qodef-e-image">
                <?php if ( ! empty( $link ) ) { ?>
                    <a itemprop="url" href="<?php echo esc_url( $link ); ?>" target="<?php echo esc_attr( $link_target ); ?>">
                        <?php if ( ! empty( $show_arrow_pointer ) ) { ?>
                            <span class="qodef-arrow-pointer-holder" <?php qode_framework_inline_style( $arrow_styles ); ?>>
                                <?php kropp_core_render_svg_icon('arrow-pointer-clients'); ?>
                            </span>
                        <?php } ?>
                <?php } ?>
                        <?php if ( ! empty( $client_svg_path ) ) { ?>
                        <span class="qodef-e-svg">
                            <?php echo qode_framework_wp_kses_html( 'html', $client_svg_path ); ?>
                        </span>
                        <?php } ?>
                        <?php if ( ! empty( $client_svg_hover_path ) ) { ?>
                            <span class="qodef-e-svg-hover">
                            <?php echo qode_framework_wp_kses_html( 'html', $client_svg_hover_path ); ?>
                        </span>
                        <?php } ?>
                    <?php if ( ! empty( $link ) ) { ?>
                    </a>
                <?php } ?>
            </div>
        <?php } ?>
    <?php } ?>

<?php } ?>
